function [ package_up_channel ] = upconvert_package_to_passband_OFDM( package, pulse, fs, f0, R, N, BlockLength )
%upconvert a package from baseband to passband
%   Detailed explanation goes here

% % This determines how many times one symbol is repeated in a row (so it
% % depends on T which is determined in the config section on top of this
% % script.) This is NOT pulse shaping
% symbol_repetition = ones(1,T);
% 
% % Upsample the signal in baseband such that each symbol is repeated T
% % times. This upsampling operation will insert zeros in the first place, 
% % after that it will filter with the specified filter (which will just copy
% % the symbols if the filter containes only ones)
% tx = upfirdn(channel_input, symbol_repetition, T, 1);

if isempty(package)
    return;
end

% We have a sampling frequency fs=44100 and a carrier frequency of f0=fs/k
Ts = 1/fs;          % duration of one sample
T0 = 1/f0;          % duration of one period in the passband
Tr = 1/R;           % duration of one symbol in the passband
k = Tr/Ts;    % samples per symbol in passband



% create time axis
t_signal = Ts:Ts:length(package)*Ts;

% create cos and sin for the specified time axis
cos_shape = sqrt(2)*cos(2*pi*f0*t_signal);
sin_shape = -sqrt(2)*sin(2*pi*f0*t_signal);

fhalfBandwidth = 1/2*BlockLength/N*fs;
comp_shape = exp(-1i*2*pi*fhalfBandwidth*t_signal);

package = package .* comp_shape;


% multiply the symbols to be transmitted with the cos and sine
package_up_sc = cos_shape .* real(package);
package_up_ss = sin_shape .* imag(package);

% signal upsampled to passband
package_up_channel = package_up_sc + package_up_ss;



end

